﻿using Hims.Api.Models;
using Hims.Api.Utilities;
using Hims.Domain.Helpers;
using Hims.Domain.Services;
using Hims.Shared.DataFilters;
using Hims.Shared.EntityModels;
using Hims.Shared.Library.Enums;
using Hims.Shared.UserModels;
using Hims.Shared.UserModels.Common;
using Hims.Shared.UserModels.InPatientsView;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Org.BouncyCastle.Asn1.IsisMtt.X509;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Hims.Api.Controllers
{
    /// <inheritdoc />
    [Authorize]
    [Route("api/inpatients-view")]
    public class InPatientsViewController : BaseController
    {
        /// <summary>
        /// The working Hour  services.
        /// </summary>
        private readonly IInPatientsViewService service;
        /// <summary>
        /// The AES helper.
        /// </summary>
        private readonly IAESHelper aesHelper;

        /// <inheritdoc />
        public InPatientsViewController(IInPatientsViewService service, IAESHelper aesHelper)
        {
            this.service = service;
            this.aesHelper = aesHelper;
        }

        /// <summary>
        /// Inserts the  asynchronous.
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [Route("fetch")]
        public async Task<ActionResult> FetchAsync([FromBody] PayloadModel model)
        {
            var data = await this.service.FetchAsync(model);
            foreach (var item in data)
            {
                item.EncryptedAdmissionId = this.aesHelper.Encode(item.AdmissionId.ToString());
            }
            return Success(new GenericResponse
            {
                Data = data,
                Status = GenericStatus.Success,
            });           
        }

        /// <summary>
        /// Inserts the  asynchronous.
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        [Route("fetch-beds")]
        public async Task<ActionResult> FetchBedsAsync([FromBody] PayloadBedsModel model)
        {
            var data = await this.service.FetchBeds(model);
            return Success(new GenericResponse
            {
                Data = data,
                Status = GenericStatus.Success,
            });
        }

    }
}
